/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMocAlgo;
import cds.aladin.PlanTMoc;
import cds.moc.TMoc;

public class PlanTMocAlgo
extends PlanTMoc {
    public PlanTMocAlgo(Aladin aladin, String label, PlanMoc[] pList, int op, int order, long maxSize) {
        super(aladin);
        PlanMoc p1 = pList[0];
        p1.copy(this);
        this.type = 23;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = PlanTMocAlgo.getFonction(p1, pList, op, order);
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "TMOC computation: " + Plan.Tp[this.type] + " => " + s);
        try {
            this.moc = p1.getMoc().getTimeMoc().clone();
            if (op == 4) {
                this.moc = this.moc.complement();
            } else if (op == 5) {
                ((TMoc)this.moc).setMocOrder(order);
            } else {
                block8: for (int i = 1; i < pList.length; ++i) {
                    TMoc m1 = (TMoc)this.moc;
                    TMoc m2 = pList[i].getMoc().getTimeMoc();
                    if (!m1.isCompatible(m2)) {
                        throw new Exception("Uncompatible MOCs");
                    }
                    if (order >= 0) {
                        m1.setMocOrder(order);
                        m2.setMocOrder(order);
                    }
                    switch (op) {
                        case 0: {
                            this.moc = m1.union(m2);
                            continue block8;
                        }
                        case 1: {
                            this.moc = m1.intersection(m2);
                            continue block8;
                        }
                        case 2: {
                            this.moc = m1.subtraction(m2);
                            continue block8;
                        }
                        case 3: {
                            this.moc = m1.difference(m2);
                        }
                    }
                }
            }
            if (maxSize != -1L) {
                this.moc.reduction(maxSize);
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        this.flagOk = true;
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    @Override
    protected void launchLoading() {
    }

    private static String getFonction(PlanMoc p1, PlanMoc[] pList, int op, int order) {
        return PlanMocAlgo.getFonction(p1, pList, op, order);
    }
}

